/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.cloudkey.service.impl;

import com.tp_link.eap.domain.cloud.ModelFw;
import com.tp_link.eap.domain.cloudkey.DiskCondition;
import com.tp_link.eap.monitor.c.c;
import com.tp_link.eap.monitor.c.d;
import com.tp_link.eap.monitor.cloud.d.b.g;
import com.tp_link.eap.monitor.cloudkey.model.CloudKeyEntry;
import com.tp_link.eap.monitor.cloudkey.service.a;
import com.tp_link.eap.monitor.cloudkey.service.impl.b;
import com.tp_link.eap.monitor.cloudkey.service.impl.e;
import com.tp_link.eap.monitor.cloudkey.service.impl.f;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.service.CSSettingService;
import com.tp_link.eap.util.l;
import com.tplink.eap.cloudsdk.DeviceInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="cloudKeyService")
public class CloudKeyServiceImpl
implements a {
    private static final Logger d = LoggerFactory.getLogger(CloudKeyServiceImpl.class);
    public static final String a = "progress";
    public static final String b = "upgradeType";
    public static final String c = "upgradeStatus";
    private static final String e = "uci commit";
    private static final String f = "userconfig save";
    private static final String g = "sync";
    private static final String h = String.format("%s && %s && %s", "uci commit", "userconfig save", "sync");
    private static final String i = "uci get system.settings.";
    private static final String j = "uci set system.settings.";
    private static final String k = "uci get system.settings.timezone";
    private static final String l = "uci set system.settings.timezone=";
    private static final String m = "uci get system.settings.primary_ntp";
    private static final String n = "uci set system.settings.primary_ntp=";
    private static final String o = "uci get system.settings.secondary_ntp";
    private static final String p = "uci set system.settings.secondary_ntp=";
    private static final String q = "uci get system.settings.reset_button";
    private static final String r = "uci set system.settings.reset_button=";
    private static final String s = "date +'%Y-%m-%d %H:%M:%S'";
    private static final String t = "cat /proc/uptime";
    private static final String u = "/etc/init.d/smartip restart";
    private static final String v = "/etc/init.d/ntpclient restart";
    private static final String w = "uci get smartip.settings.";
    private static final String x = "uci set smartip.settings.";
    private static final String y = "uci get smartip.settings.lantype";
    private static final String z = "uci set smartip.settings.lantype=";
    private static final String A = "uci get smartip.settings.ip";
    private static final String B = "uci set smartip.settings.ip=";
    private static final String C = "uci get smartip.settings.mask";
    private static final String D = "uci set smartip.settings.mask=";
    private static final String E = "uci get smartip.settings.gw";
    private static final String F = "uci set smartip.settings.gw=";
    private static final String G = "uci get smartip.settings.pridns";
    private static final String H = "uci set smartip.settings.pridns=";
    private static final String I = "uci get smartip.settings.secdns";
    private static final String J = "uci set smartip.settings.secdns=";
    private static final String K = "uci get smartip.settings.fallbackip";
    private static final String L = "uci set smartip.settings.fallbackip=";
    private static final String M = "uci get smartip.settings.fallbackmask";
    private static final String N = "uci set smartip.settings.fallbackmask=";
    private static final String O = "df";
    private static final String P = "reboot";
    private static final String Q = "poweroff";
    private static final String R = "factoryreset";
    private static final String S = "eapcontroller-reset";
    private static final String T = String.format("%s && %s && %s", "factoryreset", "eapcontroller-reset", "reboot");
    private static final String U = "/tmp/firmware.bin";
    private static final String V = System.getProperty("eap.home", ".") + File.separatorChar + "data/cloudkey-firmware/firmware.bin";
    private static final String W = "/tmp/sysinfo/version.json";
    private static final String X = "firmware_check ";
    private static final String Y = "firmware_version ";
    private static final String Z = "firmware_upgrade ";
    private static final String aa = "mkdir ";
    private static final String ab = "system-led-on";
    private static final String ac = "system-led-off";
    private static final String ad = "system-led-blink";
    private static final long ae = 500L;
    private static final String af = "0";
    private static final String ag = "255";
    private static final String ah = "254";
    private static final String ai = "253";
    private static final String aj = "252";
    private static final String ak = "251";
    private static final int al = 25;
    private static final int am = 240;
    private static final long an = 86400L;
    private static final String ao = "blkid";
    private static final String ap = "blkid -g";
    private Map<String, String> aq = new HashMap<String, String>();
    private Map<String, String> ar = new HashMap<String, String>();
    private Future as;
    private AtomicInteger at = new AtomicInteger();
    private String au;
    private String av;
    private ResErrorCode aw = ResErrorCode.a;
    private Object ax = new Object();
    private OperationResponse ay;
    private e az = com.tp_link.eap.monitor.cloudkey.service.impl.e.a;
    private boolean aA = false;
    private Future aB;
    private ExecutorService aC = Executors.newCachedThreadPool();
    private static final String aD = "timeZone";
    @Autowired
    private CSSettingService aE;
    @Autowired
    private com.tp_link.eap.monitor.cloud.device.service.a aF;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.f aG;
    @Autowired
    private com.tp_link.eap.monitor.cloud.clouduser.service.a aH;

    @Override
    public OperationResponse getDefaultCloudKeyConfig(ControlType controlType, JSONObject reqObj) {
        CloudKeyEntry cloudKeyEntry = new CloudKeyEntry();
        cloudKeyEntry.setTimezone(com.tp_link.eap.util.n.a.a((String)this.getCloudKeySetting("timezone")));
        return new OperationResponse(ResErrorCode.a, (Object)cloudKeyEntry);
    }

    @Override
    public OperationResponse getCloudKeyStatus(ControlType controlType, JSONObject reqObj) {
        CloudKeyEntry cloudKeyEntry = new CloudKeyEntry();
        cloudKeyEntry.setDeviceName(this.aE.getCSSetting().getControllerName());
        cloudKeyEntry.setModel(this.getCloudKeySetting("model"));
        cloudKeyEntry.setMacAddress(this.getCloudKeySetting("mac"));
        cloudKeyEntry.setFirmwareVersion(this.getCloudKeySetting("firmware"));
        cloudKeyEntry.setSystemTime(this.getCloudKeySetting("systemTime"));
        cloudKeyEntry.setUpTime(this.getCloudKeySetting("uptime"));
        List<DiskCondition> list = this.e();
        cloudKeyEntry.setCloudKeySpace(list);
        return new OperationResponse(ResErrorCode.a, (Object)cloudKeyEntry);
    }

    @Override
    public OperationResponse getCloudKeyConfig(ControlType controlType, JSONObject reqObj) {
        CloudKeyEntry cloudKeyEntry = new CloudKeyEntry();
        cloudKeyEntry.setDeviceName(this.aE.getCSSetting().getControllerName());
        cloudKeyEntry.setTimezone(com.tp_link.eap.util.n.a.a((String)this.getCloudKeySetting("timezone")));
        cloudKeyEntry.setNtpServerI(this.getCloudKeySetting("ntpServerI"));
        cloudKeyEntry.setNtpServerII(this.getCloudKeySetting("ntpServerII"));
        cloudKeyEntry.setResetButton(this.getCloudKeySetting("resetButton").equals("on"));
        Integer n2 = Integer.parseInt(this.getCloudKeySetting("mode"));
        cloudKeyEntry.setMode(n2);
        if (0 == n2) {
            cloudKeyEntry.setIp(this.getCloudKeySetting("ip"));
            cloudKeyEntry.setMask(this.getCloudKeySetting("mask"));
            cloudKeyEntry.setGateway(this.getCloudKeySetting("gateway"));
            cloudKeyEntry.setPrimaryDns(this.getCloudKeySetting("primaryDns"));
            cloudKeyEntry.setSecondaryDns(this.getCloudKeySetting("secondaryDns"));
        }
        cloudKeyEntry.setFallbackIp(this.getCloudKeySetting("fallbackIp"));
        cloudKeyEntry.setFallbackMask(this.getCloudKeySetting("fallbackMask"));
        return new OperationResponse(ResErrorCode.a, (Object)cloudKeyEntry);
    }

    @Override
    public OperationResponse setCloudKeyBasicConfig(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        this.aF.setControllerName(jSONObject.optString("deviceName"));
        OperationResponse operationResponse = this.setCloudKeySetting("timezone", com.tp_link.eap.util.n.a.a((Integer)jSONObject.optInt("timezone")));
        if (!operationResponse.success()) {
            return operationResponse;
        }
        operationResponse = this.setCloudKeySetting("ntpServerI", jSONObject.optString("ntpServerI"));
        if (!operationResponse.success()) {
            return operationResponse;
        }
        operationResponse = this.setCloudKeySetting("ntpServerII", jSONObject.optString("ntpServerII"));
        if (!operationResponse.success()) {
            return operationResponse;
        }
        operationResponse = this.setCloudKeySetting("resetButton", jSONObject.optBoolean("resetButton") ? "on" : "off");
        if (!operationResponse.success()) {
            return operationResponse;
        }
        this.d();
        this.c(v);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse setCloudKeyNetworkConfig(ControlType controlType, JSONObject reqObj) {
        Object object;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        Integer n2 = jSONObject.optInt("mode");
        if (0 == n2) {
            if (!com.tp_link.eap.util.p.c.a((String)jSONObject.optString("ip"))) {
                return new OperationResponse(ResErrorCode.ad);
            }
            if (!com.tp_link.eap.util.p.c.c((String)jSONObject.optString("mask"))) {
                return new OperationResponse(ResErrorCode.ae);
            }
            if (!com.tp_link.eap.util.p.c.a((String)jSONObject.optString("gateway"))) {
                return new OperationResponse(ResErrorCode.ae);
            }
            if (!com.tp_link.eap.util.p.c.a((String)jSONObject.optString("primaryDns"))) {
                return new OperationResponse(ResErrorCode.af);
            }
            object = jSONObject.optString("secondaryDns");
            if (jSONObject.get("secondaryDns") instanceof JSONNull || StringUtils.isEmpty((String)object)) {
                object = "0.0.0.0";
            } else if (!com.tp_link.eap.util.p.c.a((String)object)) {
                return new OperationResponse(ResErrorCode.af);
            }
            OperationResponse operationResponse = this.setCloudKeySetting("mode", n2 + "");
            if (!operationResponse.success()) {
                return operationResponse;
            }
            operationResponse = this.setCloudKeySetting("ip", jSONObject.optString("ip"));
            if (!operationResponse.success()) {
                return operationResponse;
            }
            operationResponse = this.setCloudKeySetting("mask", jSONObject.optString("mask"));
            if (!operationResponse.success()) {
                return operationResponse;
            }
            operationResponse = this.setCloudKeySetting("gateway", jSONObject.optString("gateway"));
            if (!operationResponse.success()) {
                return operationResponse;
            }
            operationResponse = this.setCloudKeySetting("primaryDns", jSONObject.optString("primaryDns"));
            if (!operationResponse.success()) {
                return operationResponse;
            }
            operationResponse = this.setCloudKeySetting("secondaryDns", (String)object);
            if (!operationResponse.success()) {
                return operationResponse;
            }
        } else if (1 == n2) {
            if (controlType == ControlType.c || controlType == ControlType.d) {
                object = this.setCloudKeySetting("mode", String.valueOf(n2));
                if (!object.success()) {
                    return object;
                }
                if (com.tp_link.eap.util.p.c.a((String)jSONObject.optString("fallbackIp")) && !(object = this.setCloudKeySetting("fallbackIp", jSONObject.optString("fallbackIp"))).success()) {
                    return object;
                }
                if (com.tp_link.eap.util.p.c.c((String)jSONObject.optString("fallbackMask")) && !(object = this.setCloudKeySetting("fallbackMask", jSONObject.optString("fallbackMask"))).success()) {
                    return object;
                }
            } else {
                if (!com.tp_link.eap.util.p.c.a((String)jSONObject.optString("fallbackIp"))) {
                    return new OperationResponse(ResErrorCode.aa);
                }
                if (!com.tp_link.eap.util.p.c.c((String)jSONObject.optString("fallbackMask"))) {
                    return new OperationResponse(ResErrorCode.ab);
                }
                object = this.setCloudKeySetting("mode", n2 + "");
                if (!object.success()) {
                    return object;
                }
                object = this.setCloudKeySetting("fallbackIp", jSONObject.optString("fallbackIp"));
                if (!object.success()) {
                    return object;
                }
                object = this.setCloudKeySetting("fallbackMask", jSONObject.optString("fallbackMask"));
                if (!object.success()) {
                    return object;
                }
            }
        } else {
            d.warn("Unrecognized network mode: {}", (Object)n2);
            return com.tp_link.eap.util.e.aZ;
        }
        this.d();
        object = this.c();
        com.tp_link.eap.monitor.cloud.proxy.a.a.e();
        return object;
    }

    @Override
    public OperationResponse getCloudKeyFirmware(ControlType controlType, JSONObject reqObj) {
        CloudKeyEntry cloudKeyEntry = new CloudKeyEntry();
        cloudKeyEntry.setFirmwareVersion(this.getCloudKeySetting("firmware"));
        ModelFw modelFw = this.aG.getModelInfo(this.getCloudKeySetting("model"));
        if (modelFw != null && com.tp_link.eap.monitor.c.a.a(cloudKeyEntry.getFirmwareVersion(), modelFw.getLastFwVer()) < 0) {
            cloudKeyEntry.setLastFirmwareVersion(modelFw.getLastFwVer());
            cloudKeyEntry.setFwReleaseLog(modelFw.getFwReleaseLog());
        }
        return new OperationResponse(ResErrorCode.a, (Object)cloudKeyEntry);
    }

    @Override
    public OperationResponse getCloudKeyRebootTime(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("rebootTime", 240);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse cloudKeyReboot(ControlType controlType, JSONObject reqObj) {
        return this.c(P);
    }

    @Override
    public OperationResponse cloudKeyPowerOff(ControlType controlType, JSONObject reqObj) {
        return this.c(Q);
    }

    @Override
    public OperationResponse getCloudKeyResetTime(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("resetTime", 240);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse cloudKeyFactoryReset(ControlType controlType, JSONObject reqObj) {
        try {
            this.aH.resetBindingAccount();
            this.cloudLedBlink(500L);
            com.tp_link.eap.util.m.b.f((String)T);
        }
        catch (IOException iOException) {
            d.error(iOException.getMessage());
            return com.tp_link.eap.util.e.aY;
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getCloudKeyUpgradeTime(boolean startUpMaintenceFuture, boolean checkFwVersion) {
        boolean bl = false;
        Object object = this.ax;
        synchronized (object) {
            if (!this.az.equals((Object)com.tp_link.eap.monitor.cloudkey.service.impl.e.a)) {
                d.debug("Current status is {}.", (Object)this.az);
                if (this.az.equals((Object)com.tp_link.eap.monitor.cloudkey.service.impl.e.b)) {
                    return new OperationResponse(ResErrorCode.eX);
                }
                return new OperationResponse(ResErrorCode.eN);
            }
            this.az = com.tp_link.eap.monitor.cloudkey.service.impl.e.d;
        }
        object = this.a(X + V);
        String string = "";
        if (checkFwVersion) {
            string = this.a(Y + V + " " + W);
        }
        Object object2 = this.ax;
        synchronized (object2) {
            Object object3;
            this.ay = this.d((String)object);
            if (!this.ay.success()) {
                d.debug("Checks firmware result: invalid firmware.");
                com.tp_link.eap.monitor.c.a.d(V);
                this.az = com.tp_link.eap.monitor.cloudkey.service.impl.e.a;
                return this.ay;
            }
            this.az = com.tp_link.eap.monitor.cloudkey.service.impl.e.e;
            if (checkFwVersion) {
                String string2;
                this.ay = this.d(string);
                if (!this.ay.success()) {
                    d.debug("Failed to get version from firmware.");
                    com.tp_link.eap.monitor.c.a.d(V);
                    this.az = com.tp_link.eap.monitor.cloudkey.service.impl.e.a;
                    return this.ay;
                }
                object3 = this.a("firmware-version", this.e(W));
                if (com.tp_link.eap.monitor.c.a.a((String)object3, string2 = this.getCloudKeySetting("firmware")) < 0) {
                    d.debug("Version of upgrade firmware is lower than version of current firmware.");
                    this.az = com.tp_link.eap.monitor.cloudkey.service.impl.e.a;
                    bl = true;
                }
            }
            if (bl) {
                this.aA = true;
            } else {
                this.aA = false;
                if (startUpMaintenceFuture) {
                    object3 = Executors.newFixedThreadPool(1);
                    this.aB = object3.submit(new f(this, null));
                    object3.shutdown();
                }
            }
        }
        object2 = new JSONObject();
        object2.put((Object)"upgradeTime", (Object)25);
        object2.put((Object)"rebootTime", (Object)240);
        object2.put((Object)"firmwareDegrade", (Object)bl);
        return new OperationResponse(ResErrorCode.a, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse cloudKeyUpgrade(boolean cancelUpMaintenceFuture) {
        Object object;
        boolean bl;
        Object object2 = this.ax;
        synchronized (object2) {
            bl = this.ay.success();
            this.az = com.tp_link.eap.monitor.cloudkey.service.impl.e.f;
            if (cancelUpMaintenceFuture && this.aB != null && !this.aB.isDone()) {
                this.aB.cancel(true);
            }
        }
        if (bl) {
            com.tp_link.eap.monitor.cloud.d.b.e.a(com.tp_link.eap.monitor.cloud.d.b.g.b);
            object = String.format("mv -f %s %s", V, U);
            this.c((String)object);
            if (this.aA) {
                d.debug("Need to reset controller before upgrade.");
                this.c(S);
            }
            object2 = this.c("firmware_upgrade /tmp/firmware.bin");
        } else {
            object2 = new OperationResponse(ResErrorCode.b);
        }
        object = this.ax;
        synchronized (object) {
            this.az = com.tp_link.eap.monitor.cloudkey.service.impl.e.a;
        }
        d.warn("Failed to upgrade OC200.");
        com.tp_link.eap.monitor.c.a.d(U);
        return object2;
    }

    @Override
    public OperationResponse getCloudKeyUpgradeTime(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            d.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = b;
        if (!jSONObject.has(string)) {
            d.warn("Parameter '{}' is missing.", (Object)string);
            return com.tp_link.eap.util.e.aZ;
        }
        int n2 = jSONObject.getInt(string);
        if (n2 == 0) {
            File file = new File(V);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try (InputStream inputStream = com.tp_link.eap.util.g.a.b((HttpServletRequest)request);
                 FileOutputStream fileOutputStream = new FileOutputStream(file);){
                int n3;
                byte[] byArray = new byte[1024];
                while ((n3 = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n3);
                }
            }
            catch (IOException iOException) {
                return new OperationResponse(ResErrorCode.eO);
            }
        }
        return this.getCloudKeyUpgradeTime(true, n2 == 0);
    }

    @Override
    public OperationResponse getCloudKeyUpgradeTime(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        JSONObject jSONObject = reqData.optJSONObject("params");
        if (jSONObject == null) {
            d.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = b;
        if (!jSONObject.has(string)) {
            d.warn("Parameter '{}' is missing.", (Object)string);
            return com.tp_link.eap.util.e.aZ;
        }
        int n2 = jSONObject.getInt(string);
        if (n2 == 0) {
            File file = new File(V);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                ((OutputStream)fileOutputStream).write(fileContent, 0, fileContent.length);
            }
            catch (IOException iOException) {
                return new OperationResponse(ResErrorCode.eO);
            }
        }
        return this.getCloudKeyUpgradeTime(true, n2 == 0);
    }

    @Override
    public OperationResponse cloudKeyUpgrade(ControlType controlType, JSONObject reqObj) {
        return this.cloudKeyUpgrade(true);
    }

    @Override
    public ResErrorCode onlineCheckCKLastFw(boolean isManual) {
        ResErrorCode resErrorCode = ResErrorCode.b;
        if (com.tp_link.eap.util.l.b()) {
            d.error("Invalid call, this function can only be used by hardware controller");
            return resErrorCode;
        }
        DeviceInfo deviceInfo = new com.tp_link.eap.monitor.cloud.device.a().getDeviceInfo();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(deviceInfo.getDeviceModel());
        stringBuilder.append(" ");
        stringBuilder.append(deviceInfo.getDeviceHwVer());
        ModelFw modelFw = this.aG.getModelInfo(stringBuilder.toString());
        long l2 = System.currentTimeMillis() / 1000L;
        if (isManual && modelFw != null && l2 - modelFw.getManualCheckTime() < 86400L && l2 >= modelFw.getManualCheckTime()) {
            d.debug("The time since last fw check time of modelModelVersion({}) is less than 24 hours.", (Object)modelFw.getModelModelVersion());
            resErrorCode = ResErrorCode.a;
            return resErrorCode;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"deviceId", (Object)deviceInfo.getDeviceId());
        jSONObject.put((Object)"hwId", (Object)deviceInfo.getHwId());
        jSONObject.put((Object)"oemId", (Object)deviceInfo.getOemId());
        jSONObject.put((Object)"fwId", (Object)deviceInfo.getFwId());
        jSONObject.put((Object)"devFwCurrentVer", (Object)com.tp_link.eap.monitor.c.a.c(deviceInfo.getFwVer()));
        jSONObject.put((Object)"locale", (Object)"en_US");
        JSONObject jSONObject2 = null;
        try {
            jSONObject2 = com.tp_link.eap.monitor.cloud.d.b.c.a(jSONObject);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            d.debug(socketTimeoutException.toString(), (Throwable)socketTimeoutException);
            resErrorCode = ResErrorCode.eJ;
        }
        catch (SocketException | UnknownHostException iOException) {
            d.debug(iOException.toString(), (Throwable)iOException);
            resErrorCode = ResErrorCode.eL;
        }
        catch (IOException iOException) {
            d.info("Exception occurs when sending request('{}'): {}.", (Object)"getIntlFwList", (Object)iOException.toString());
            d.debug(iOException.toString(), (Throwable)iOException);
        }
        if (jSONObject2 != null) {
            try {
                int n2 = jSONObject2.getInt("error_code");
                if (n2 == 0) {
                    JSONObject jSONObject3 = jSONObject2.getJSONObject("result");
                    JSONArray jSONArray = jSONObject3.optJSONArray("fwList");
                    resErrorCode = ResErrorCode.a;
                    if (jSONArray != null && jSONArray.size() > 0) {
                        JSONObject jSONObject4;
                        if (modelFw == null) {
                            modelFw = new ModelFw();
                            modelFw.setCategory(ModelFw.DeviceCategory.CLOUD_KEY.getCategory());
                            modelFw.setModelModelVersion(stringBuilder.toString());
                            modelFw.setEncryptedHwId(com.tp_link.eap.monitor.cloud.e.a.c(deviceInfo.getHwId()));
                            modelFw.setEncryptedOemId(com.tp_link.eap.monitor.cloud.e.a.c(deviceInfo.getOemId()));
                            modelFw.setManualCheckTime(0L);
                        }
                        if (isManual) {
                            modelFw.setManualCheckTime(l2);
                        }
                        if ((jSONObject4 = jSONArray.getJSONObject(0)).has("fwReleaseLog")) {
                            modelFw.setFwReleaseLog(jSONObject4.getString("fwReleaseLog"));
                        }
                        if (jSONObject4.has("fwTitle")) {
                            modelFw.setFwTitle(jSONObject4.getString("fwTitle"));
                        }
                        modelFw.setFwType(jSONObject4.getInt("fwType"));
                        String string = jSONObject4.getString("fwUrl");
                        modelFw.setFwUrl(string);
                        modelFw.setFwMD5(jSONObject4.getString("fwMD5"));
                        modelFw.setLastFwVer(jSONObject4.getString("fwVer"));
                        this.aG.refreshModelInfo(modelFw);
                    }
                    return resErrorCode;
                }
            }
            catch (JSONException jSONException) {
                d.warn(jSONException.toString(), (Throwable)jSONException);
            }
        }
        return resErrorCode;
    }

    @Override
    public OperationResponse onlineCheckCKLastFw(ControlType controlType, JSONObject reqObj) {
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        return new OperationResponse(this.onlineCheckCKLastFw(true));
    }

    @Override
    public OperationResponse downloadCKFw(ControlType controlType, JSONObject reqObj) {
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        com.tp_link.eap.monitor.cloudkey.service.impl.a a2 = new com.tp_link.eap.monitor.cloudkey.service.impl.a(this);
        return new OperationResponse(this.a(a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse cancelDownloadCKFw(ControlType controlType, JSONObject reqObj) {
        Object object = this.ax;
        synchronized (object) {
            if (!this.az.equals((Object)com.tp_link.eap.monitor.cloudkey.service.impl.e.b)) {
                d.info("Downloading firmware of cloud key isn't running.");
                return new OperationResponse(ResErrorCode.b);
            }
            this.as.cancel(true);
        }
        return new OperationResponse(ResErrorCode.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getCKFwDownloadProgress(ControlType controlType, JSONObject reqObj) {
        int n2;
        Object object = this.ax;
        synchronized (object) {
            if (!this.az.equals((Object)com.tp_link.eap.monitor.cloudkey.service.impl.e.b) && this.as != null && !this.as.isCancelled() && this.at.get() < 100) {
                d.warn("Failed to download complete firmware of cloud key.");
                return new OperationResponse(this.aw);
            }
            n2 = this.at.get();
        }
        object = new JSONObject();
        object.put((Object)a, (Object)n2);
        return new OperationResponse(ResErrorCode.a, ResErrorCode.a.b(), object);
    }

    @Override
    public OperationResponse getCKUpgradeStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = new JSONObject();
        int n2 = this.b();
        jSONObject.put((Object)c, (Object)n2);
        switch (com.tp_link.eap.monitor.cloudkey.service.impl.e.a(n2)) {
            case b: {
                jSONObject.put((Object)a, (Object)this.at.get());
                break;
            }
            case c: 
            case d: 
            case e: 
            case f: {
                jSONObject.put((Object)"upgradeTime", (Object)25);
                jSONObject.put((Object)"rebootTime", (Object)240);
                break;
            }
        }
        return new OperationResponse(ResErrorCode.a, ResErrorCode.a.b(), (Object)jSONObject);
    }

    @Override
    public OperationResponse downloadAndUpgradeCK(ControlType controlType, JSONObject reqObj) {
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        b b2 = new b(this);
        ResErrorCode resErrorCode = this.a(b2);
        if (resErrorCode.equals((Object)ResErrorCode.a)) {
            if (this.b() == com.tp_link.eap.monitor.cloudkey.service.impl.e.c.a()) {
                OperationResponse operationResponse = this.getCloudKeyUpgradeTime(false, false);
                if (operationResponse.getErrorCode() == ResErrorCode.a.a()) {
                    return this.cloudKeyUpgrade(true);
                }
                return operationResponse;
            }
            return new OperationResponse(resErrorCode);
        }
        return new OperationResponse(resErrorCode);
    }

    @Override
    public OperationResponse checkCKCloudFw(ControlType controlType, JSONObject reqObj) {
        if (!this.az.equals((Object)com.tp_link.eap.monitor.cloudkey.service.impl.e.a)) {
            d.debug("Current status is {}.", (Object)this.az);
            if (this.az.equals((Object)com.tp_link.eap.monitor.cloudkey.service.impl.e.b)) {
                return new OperationResponse(ResErrorCode.eX);
            }
            return new OperationResponse(ResErrorCode.eN);
        }
        return this.getCloudKeyUpgradeTime(true, false);
    }

    @Override
    public OperationResponse getCloudKeyTimeZone(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)aD, (Object)com.tp_link.eap.util.n.a.a((String)this.getCloudKeySetting("timezone")));
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    @Override
    public OperationResponse setCloudKeyTimeZone(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        String string = com.tp_link.eap.util.n.a.a((Integer)jSONObject.optInt(aD));
        OperationResponse operationResponse = this.setCloudKeySetting("timezone", string);
        this.d();
        this.c(v);
        return operationResponse;
    }

    @Override
    public OperationResponse getResetButtonStatus(ControlType controlType, JSONObject reqObj) {
        CloudKeyEntry cloudKeyEntry = new CloudKeyEntry();
        cloudKeyEntry.setResetButton(this.getCloudKeySetting("resetButton").equals("on"));
        return new OperationResponse(ResErrorCode.a, (Object)cloudKeyEntry);
    }

    @Override
    public OperationResponse setResetButtonStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        OperationResponse operationResponse = this.setCloudKeySetting("resetButton", jSONObject.optBoolean("resetButton") ? "on" : "off");
        this.d();
        return operationResponse;
    }

    @Override
    public String getCloudKeySetting(String field) {
        switch (field) {
            case "timezone": {
                return this.a(k);
            }
            case "ntpServerI": {
                return this.a(m);
            }
            case "ntpServerII": {
                return this.a(o);
            }
            case "resetButton": {
                return this.a(q);
            }
            case "mode": {
                return this.a(y);
            }
            case "ip": {
                return this.a(A);
            }
            case "mask": {
                return this.a(C);
            }
            case "gateway": {
                return this.a(E);
            }
            case "primaryDns": {
                return this.a(G);
            }
            case "secondaryDns": {
                return this.a(I);
            }
            case "fallbackIp": {
                return this.a(K);
            }
            case "fallbackMask": {
                return this.a(M);
            }
            case "systemTime": {
                return this.b(s);
            }
            case "uptime": {
                String string = this.a(t);
                return this.f(string);
            }
            case "model": {
                return this.a("product_name", this.e("/tmp/sysinfo/device-info.json")) + " " + this.a("product_version", this.e("/tmp/sysinfo/device-info.json"));
            }
            case "mac": {
                return this.a("mac", this.e("/tmp/sysinfo/tddp.json"));
            }
            case "firmware": {
                return this.a("firmware-version", this.e("/tmp/sysinfo/firmware-info.json"));
            }
        }
        d.warn("Unrecognized field {}", (Object)field);
        return "";
    }

    @Override
    public OperationResponse setCloudKeySetting(String field, String value) {
        if (null == value) {
            return new OperationResponse(ResErrorCode.d, (Object)(field + " is null"));
        }
        switch (field) {
            case "timezone": {
                this.i(value);
                return this.c(l + value);
            }
            case "ntpServerI": {
                return this.c(n + value);
            }
            case "ntpServerII": {
                return this.c(p + value);
            }
            case "resetButton": {
                return this.c(r + value);
            }
            case "mode": {
                return this.c(z + value);
            }
            case "ip": {
                return this.c(B + value);
            }
            case "mask": {
                return this.c(D + value);
            }
            case "gateway": {
                return this.c(F + value);
            }
            case "primaryDns": {
                return this.c(H + value);
            }
            case "secondaryDns": {
                return this.c(J + value);
            }
            case "fallbackIp": {
                return this.c(L + value);
            }
            case "fallbackMask": {
                return this.c(N + value);
            }
        }
        d.warn("Unrecognized field {}", (Object)field);
        return new OperationResponse(ResErrorCode.d);
    }

    @Override
    public List<String> getAvailablePaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(com.tp_link.eap.util.m.b.e((String)O).getInputStream(), "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\\s+");
                if (stringArray.length < 6 || !stringArray[0].startsWith("/dev/sd")) continue;
                String string2 = this.h(stringArray[0]);
                d.debug("Get uuid {}", (Object)string2);
                if (StringUtils.isBlank((String)string2)) continue;
                if (!this.aq.containsKey(string2)) {
                    this.f();
                }
                String string3 = this.aq.get(string2);
                d.debug("Get label {} of uuid {}", (Object)string3, (Object)string2);
                String string4 = string3 + File.separator + "autobackup";
                if (!this.ar.containsKey(string4)) {
                    this.ar.put(string4, stringArray[5] + File.separator + "autobackup");
                    d.debug("Put label {} with path {}", (Object)string4, (Object)this.ar.get(string4));
                }
                arrayList.add(string4);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            d.warn(iOException.toString(), (Throwable)iOException);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public OperationResponse createDirectory(String path) {
        return this.c(aa + path);
    }

    @Override
    public void restartNtpClient() {
        this.d();
        this.c(v);
    }

    @Override
    public void cloudLedOn() {
        this.c(ab);
    }

    @Override
    public void cloudLedOff() {
        this.c(ac);
    }

    @Override
    public void cloudLedBlink(long blinkInterval) {
        this.c("system-led-blink " + blinkInterval);
    }

    @Override
    public String getAutoBackupFileSavingPath(String autoBackupPath) {
        if (StringUtils.isBlank((String)autoBackupPath)) {
            d.warn("label ({}) is empty", (Object)autoBackupPath);
            return "";
        }
        if (com.tp_link.eap.util.l.b()) {
            return autoBackupPath;
        }
        if (!this.ar.containsKey(autoBackupPath)) {
            this.getAvailablePaths();
        }
        d.debug("Get path {} of label {}", (Object)autoBackupPath, (Object)this.ar.get(autoBackupPath));
        return this.ar.get(autoBackupPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResErrorCode a(c c2) {
        DeviceInfo deviceInfo = new com.tp_link.eap.monitor.cloud.device.a().getDeviceInfo();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(deviceInfo.getDeviceModel());
        stringBuilder.append(" ");
        stringBuilder.append(deviceInfo.getDeviceHwVer());
        ModelFw modelFw = this.aG.getModelInfo(stringBuilder.toString());
        if (modelFw != null && !StringUtils.isBlank((String)modelFw.getFwUrl())) {
            Object object = this.ax;
            synchronized (object) {
                Object object2;
                Object object3;
                if (!this.az.equals((Object)com.tp_link.eap.monitor.cloudkey.service.impl.e.a)) {
                    d.debug("Current status is {}.", (Object)this.az);
                    if (!this.az.equals((Object)com.tp_link.eap.monitor.cloudkey.service.impl.e.b)) return ResErrorCode.eN;
                    return ResErrorCode.a;
                }
                boolean bl = com.tp_link.eap.monitor.c.a.g(V);
                String string = null;
                if (bl) {
                    try {
                        object3 = new FileInputStream(V);
                        object2 = null;
                        try {
                            string = DigestUtils.md5Hex((InputStream)object3).toUpperCase(Locale.ROOT);
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object3 != null) {
                                if (object2 != null) {
                                    try {
                                        ((InputStream)object3).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object2).addSuppressed(throwable);
                                    }
                                } else {
                                    ((InputStream)object3).close();
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        d.warn(iOException.toString());
                        d.debug(iOException.toString(), (Throwable)iOException);
                    }
                    if (!StringUtils.isBlank((String)modelFw.getFwUrl()) && !StringUtils.isBlank((String)modelFw.getFwMD5()) && modelFw.getFwMD5().equals(string) && com.tp_link.eap.monitor.c.a.a(modelFw.getLastFwVer(), this.getCloudKeySetting("firmware")) > 0) {
                        d.debug("Current firmware is downloaded in last startup.");
                        this.au = modelFw.getFwUrl();
                        this.av = modelFw.getFwMD5();
                        this.at.set(100);
                        this.aw = ResErrorCode.a;
                    }
                    if (!StringUtils.isBlank((String)modelFw.getFwUrl()) && !modelFw.getFwUrl().equals(this.au) || StringUtils.isBlank((String)string) || !string.equals(this.av)) {
                        d.debug("Deletes old cloud key firmware as download url has changed or firmware is changed unexpectedly.");
                        com.tp_link.eap.monitor.c.a.d(V);
                    } else if (this.at.get() >= 100) {
                        d.info("Firmware of cloud key has already existed, so need't be downloaded.");
                        return ResErrorCode.a;
                    }
                }
                this.aw = ResErrorCode.a;
                this.az = com.tp_link.eap.monitor.cloudkey.service.impl.e.b;
                object3 = new d(modelFw.getFwUrl(), V, this.at, new com.tp_link.eap.monitor.cloudkey.service.impl.c(this, modelFw, c2));
                object2 = Executors.newFixedThreadPool(1);
                this.as = object2.submit(object3);
                object2.shutdown();
                return ResErrorCode.a;
            }
        }
        d.debug("Invalid model firmware info of cloud key.");
        return ResErrorCode.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int b() {
        int n2;
        Object object = this.ax;
        synchronized (object) {
            n2 = this.az.a();
        }
        if (n2 == com.tp_link.eap.monitor.cloudkey.service.impl.e.a.a()) {
            boolean bl = com.tp_link.eap.monitor.c.a.g(V);
            String string = null;
            if (bl) {
                Serializable serializable;
                FileInputStream fileInputStream;
                try {
                    fileInputStream = new FileInputStream(V);
                    serializable = null;
                    try {
                        string = DigestUtils.md5Hex((InputStream)fileInputStream).toUpperCase(Locale.ROOT);
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fileInputStream != null) {
                            if (serializable != null) {
                                try {
                                    ((InputStream)fileInputStream).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                            } else {
                                ((InputStream)fileInputStream).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    d.warn(iOException.toString());
                    d.debug(iOException.toString(), (Throwable)iOException);
                }
                fileInputStream = new com.tp_link.eap.monitor.cloud.device.a().getDeviceInfo();
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append(fileInputStream.getDeviceModel());
                ((StringBuilder)serializable).append(" ");
                ((StringBuilder)serializable).append(fileInputStream.getDeviceHwVer());
                ModelFw modelFw = this.aG.getModelInfo(((StringBuilder)serializable).toString());
                if (modelFw != null && !StringUtils.isBlank((String)modelFw.getFwMD5()) && modelFw.getFwMD5().equals(string) && com.tp_link.eap.monitor.c.a.a(modelFw.getLastFwVer(), this.getCloudKeySetting("firmware")) > 0) {
                    n2 = com.tp_link.eap.monitor.cloudkey.service.impl.e.c.a();
                }
            }
        }
        return n2;
    }

    private OperationResponse c() {
        return this.c(u);
    }

    private void d() {
        try {
            com.tp_link.eap.util.m.b.f((String)h);
        }
        catch (IOException iOException) {
            d.warn(iOException.toString(), (Throwable)iOException);
        }
    }

    private List<DiskCondition> e() {
        ArrayList<DiskCondition> arrayList = new ArrayList<DiskCondition>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(com.tp_link.eap.util.m.b.e((String)O).getInputStream(), "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                String[] stringArray = string.split("\\s+");
                if (stringArray.length != 6) continue;
                if (stringArray[0].equals("/dev/mmcblk0p4")) {
                    object = new DiskCondition();
                    object.setName("Disk");
                    object.setTotalSpace(this.g(stringArray[1]));
                    object.setUsedSpace(this.g(stringArray[2]));
                    arrayList.add((DiskCondition)object);
                    continue;
                }
                if (!stringArray[0].startsWith("/dev/sd") || StringUtils.isBlank((String)(object = this.h(stringArray[0])))) continue;
                if (!this.aq.containsKey(object)) {
                    this.f();
                }
                DiskCondition diskCondition = new DiskCondition();
                diskCondition.setName(this.aq.get(object));
                diskCondition.setTotalSpace(this.g(stringArray[1]));
                diskCondition.setUsedSpace(this.g(stringArray[2]));
                arrayList.add(diskCondition);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            d.warn(iOException.toString(), (Throwable)iOException);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private String a(String string) {
        try {
            String string2;
            if (string.startsWith(X) || string.startsWith(Z) || string.startsWith(Y)) {
                Process process = com.tp_link.eap.util.m.b.e((String)string);
                process.waitFor();
                return process.exitValue() + "";
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(com.tp_link.eap.util.m.b.e((String)string).getInputStream(), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (InterruptedException interruptedException) {
            d.warn("Firmware upgrade is not finished");
            return "";
        }
        catch (IOException iOException) {
            d.error("Run command {} error", (Object)string);
            return "";
        }
    }

    private String b(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(com.tp_link.eap.util.m.b.f((String)string).getInputStream(), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            d.error("Run command {} error", (Object)string);
            return "";
        }
    }

    private OperationResponse c(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(com.tp_link.eap.util.m.b.e((String)string).getInputStream(), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            bufferedReader.close();
            if (!stringBuilder.toString().equals("") && !string.equals(u)) {
                return new OperationResponse(ResErrorCode.d, (Object)stringBuilder.toString());
            }
            return new OperationResponse(ResErrorCode.a);
        }
        catch (IOException iOException) {
            d.error("Run command {} error", (Object)string);
            return new OperationResponse(ResErrorCode.eP);
        }
    }

    private OperationResponse d(String string) {
        switch (string) {
            case "0": {
                return com.tp_link.eap.util.e.bd;
            }
            case "255": {
                return new OperationResponse(ResErrorCode.eR);
            }
            case "254": {
                return new OperationResponse(ResErrorCode.eS);
            }
            case "253": {
                return new OperationResponse(ResErrorCode.eT);
            }
            case "252": {
                return new OperationResponse(ResErrorCode.eU);
            }
            case "251": {
                return new OperationResponse(ResErrorCode.eV);
            }
        }
        d.error("Unrecognized upgrade result {}, -5 to 0 is expected", (Object)string);
        return new OperationResponse(ResErrorCode.eW);
    }

    private String e(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            d.error("Read file {} error", (Object)string);
            return "";
        }
    }

    private String a(String string, String string2) {
        Map map = com.tp_link.eap.util.a.b.a((String)string2);
        Object v = map.get(string);
        if (null == v) {
            d.warn("Cannot get {} from {}", (Object)string, (Object)string2);
            return "";
        }
        return (String)v;
    }

    private String f(String string) {
        String[] stringArray = string.split("\\s+");
        if (2 != stringArray.length) {
            d.error("Get uptime error {}", (Object)string);
            return "0 days, 0h, 0m, 0s";
        }
        try {
            double d2 = Double.parseDouble(stringArray[0]);
            long l2 = (long)d2;
            long l3 = l2 % 60L;
            long l4 = (l2 /= 60L) % 60L;
            long l5 = (l2 /= 60L) % 24L;
            long l6 = l2 /= 24L;
            if (l6 < 2L) {
                return l6 + " day, " + l5 + "h " + l4 + "m " + l3 + "s";
            }
            return l6 + " days, " + l5 + "h " + l4 + "m " + l3 + "s";
        }
        catch (NumberFormatException numberFormatException) {
            d.error("Get uptime error {}", (Object)string);
            return "0 days, 0h, 0m, 0s";
        }
    }

    private Double g(String string) {
        try {
            Double d2 = Double.parseDouble(string);
            d2 = d2 / 1024.0;
            d2 = d2 / 1024.0;
            DecimalFormat decimalFormat = new DecimalFormat("#.00");
            d2 = Double.parseDouble(decimalFormat.format(d2));
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            d.warn("Cannot identify space {}", (Object)string);
            return 0.0;
        }
    }

    private void f() {
        this.c(ap);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(com.tp_link.eap.util.m.b.e((String)ao).getInputStream(), "UTF-8"));
            int n2 = 1;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("\\s+")) {
                    if (!string2.startsWith("UUID")) continue;
                    String string3 = string2.substring(string2.indexOf(34) + 1, string2.lastIndexOf(34));
                    this.aq.put(string3, "USB Disk" + n2 + ":");
                    d.debug("Put uuid {} label {} map", (Object)string3, (Object)n2);
                    ++n2;
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            d.warn(iOException.toString(), (Throwable)iOException);
        }
    }

    private String h(String string) {
        String[] stringArray;
        String string2 = this.a("blkid " + string);
        if (StringUtils.isBlank((String)string2)) {
            return "";
        }
        for (String string3 : stringArray = string2.split("\\s+")) {
            if (!string3.startsWith("UUID")) continue;
            String string4 = string3.substring(string3.indexOf(34) + 1, string3.lastIndexOf(34));
            d.debug("Get UUID of {} is {}", (Object)string, (Object)string4);
            return string4;
        }
        return "";
    }

    private void i(String string) {
        TimeZone.setDefault(TimeZone.getTimeZone(string));
        this.aC.execute(() -> {
            d.debug("Start to reload log4j2.properties");
            String string = System.getProperty("eap.home", ".") + File.separator + "properties" + File.separator + "log4j2.properties";
            System.setProperty("log4j.configurationFile", string);
            File file = new File(string);
            String string2 = System.getProperty("eap.home", ".") + File.separator + "data" + File.separator + "properties" + File.separator + "log4j2.properties";
            File file2 = new File(string2);
            File file3 = !com.tp_link.eap.util.l.b() && file2.exists() ? file2 : file;
            if (file3.exists()) {
                LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                loggerContext.setConfigLocation(file3.toURI());
            }
            d.debug("End to reload log4j2.properties");
        });
        d.info("JVM time zone has been changed.");
    }

    static /* synthetic */ String a(CloudKeyServiceImpl cloudKeyServiceImpl, String string) {
        cloudKeyServiceImpl.au = string;
        return cloudKeyServiceImpl.au;
    }

    static /* synthetic */ Logger a() {
        return d;
    }

    static /* synthetic */ Object a(CloudKeyServiceImpl cloudKeyServiceImpl) {
        return cloudKeyServiceImpl.ax;
    }

    static /* synthetic */ String b(CloudKeyServiceImpl cloudKeyServiceImpl, String string) {
        cloudKeyServiceImpl.av = string;
        return cloudKeyServiceImpl.av;
    }

    static /* synthetic */ e a(CloudKeyServiceImpl cloudKeyServiceImpl, e e2) {
        cloudKeyServiceImpl.az = e2;
        return cloudKeyServiceImpl.az;
    }

    static /* synthetic */ ResErrorCode a(CloudKeyServiceImpl cloudKeyServiceImpl, ResErrorCode resErrorCode) {
        cloudKeyServiceImpl.aw = resErrorCode;
        return cloudKeyServiceImpl.aw;
    }

    static /* synthetic */ e b(CloudKeyServiceImpl cloudKeyServiceImpl) {
        return cloudKeyServiceImpl.az;
    }
}

